<?php

declare(strict_types=1);

namespace Bongo\Estimate\Actions;

use Bongo\Estimate\Models\EstimateService;

class GetDefaultService
{
    public static function execute(): ?EstimateService
    {
        $estimateServices = EstimateService::active()
            ->orderBy('name')
            ->get();

        if (! $estimateServices || $estimateServices->isEmpty()) {
            return null;
        }

        return $estimateServices->where('default', 1)->first()
            ?? $estimateServices->first();
    }
}
