<?php

declare(strict_types=1);

namespace Bongo\Estimate\Actions;

class GetM2Price
{
    public static function forBasicPlan($totalAreaM2): int|float
    {
        $priceMatrix = config('estimate.prices') ?? config('estimate.basic');

        return self::getPriceFromMatrix($totalAreaM2, $priceMatrix);
    }

    public static function forEnhancedPlan($totalAreaM2): int|float
    {
        return self::getPriceFromMatrix($totalAreaM2, config('estimate.enhanced'));
    }

    public static function forPremierPlan($totalAreaM2): int|float
    {
        return self::getPriceFromMatrix($totalAreaM2, config('estimate.premier'));
    }

    private static function getPriceFromMatrix($totalAreaM2, array $priceMatrix = []): int|float
    {
        if (empty($priceMatrix) || count($priceMatrix) < 1) {
            return 0;
        }

        $subtotal = config('estimate.min_price');

        foreach ($priceMatrix as $noOfMeters => $price) {
            $subtotal = $price;
            if ($totalAreaM2 <= intval($noOfMeters)) {
                break;
            }
        }

        return $subtotal;
    }
}
