<?php

declare(strict_types=1);

namespace Bongo\Estimate\Actions;

use Bongo\Framework\Helpers\Tax;
use Illuminate\Contracts\Container\BindingResolutionException;

class GetPrice
{
    /** @throws BindingResolutionException */
    public static function forBasicPlan($totalAreaM2): array
    {
        $priceFromMatrix = GetM2Price::forBasicPlan($totalAreaM2);

        return self::getPricesAsArray($totalAreaM2, $priceFromMatrix);
    }

    /** @throws BindingResolutionException */
    public static function forEnhancedPlan($totalAreaM2): array
    {
        $priceFromMatrix = GetM2Price::forEnhancedPlan($totalAreaM2);

        return self::getPricesAsArray($totalAreaM2, $priceFromMatrix);
    }

    /** @throws BindingResolutionException */
    public static function forPremierPlan($totalAreaM2): array
    {
        $priceFromMatrix = GetM2Price::forPremierPlan($totalAreaM2);

        return self::getPricesAsArray($totalAreaM2, $priceFromMatrix);
    }

    /** @throws BindingResolutionException */
    private static function getPricesAsArray($totalAreaM2, $priceFromMatrix): array
    {
        $taxRate = setting('package::estimate.tax_rate', 20);

        if (config('estimate.prices_include_tax')) {
            $priceFromMatrix = Tax::excluding($priceFromMatrix, $taxRate);
        }

        $costPerM2 = ! empty($totalAreaM2) ? ($priceFromMatrix / $totalAreaM2) : 0;
        $subtotal = ! empty($priceFromMatrix) ? round($priceFromMatrix, 2) : 0;
        $tax = round(Tax::calculate($subtotal, $taxRate), 2);
        $total = round(($subtotal + $tax), 2);

        $monthsInYear = 12;
        $noOfTreatments = config('estimate.chargeable_treatments_per_year');
        $perMonth = ! empty($total)
            ? ($total * $noOfTreatments) / $monthsInYear
            : 0;

        return [
            'cost_per_m2' => $costPerM2,
            'subtotal' => $subtotal,
            'tax_rate' => $taxRate,
            'tax' => $tax,
            'total' => $total,

            'months_in_year' => $monthsInYear,
            'no_of_treatments' => $noOfTreatments,
            'per_month' => $perMonth,
        ];
    }
}
