<?php

declare(strict_types=1);

return [
    'prefix' => 'estimate',
    'backend_prefix' => 'estimates',
    'item_prefix' => 'items',
    'service_prefix' => 'estimate-services',
    'location_prefix' => 'estimate-locations',
    'plan_prefix' => 'estimate-plans',

    // Auto upgrade to V4
    'auto_upgrade_to_v4' => true,

    // Email notifications
    'email_notifications' => [
        'enabled' => true,
    ],

    // The prefix before the estimate reference
    'number_prefix' => 'KLC-',

    // Estimate Cleanup
    'cleanup_days' => 7,

    // Estimate areas, used for the map
    'map_center' => [52.600850, 1.175440], // Latitude, Longitude

    // Map Zoom Level
    'radius_map' => [ // The map in the settings > estimate areas
        'zoom_level' => 8,
    ],
    'static_map' => [ // The map on step 3, admin & email
        'zoom_level' => 19,
    ],

    // Vouchers
    'voucher_code_enabled' => false,

    // Tax
    'prices_include_tax' => false,

    // Ad-hoc costs
    'survey_cost' => 97,

    // Standard treatments & visits
    'treatments_per_year' => 11,
    'chargeable_treatments_per_year' => 7,

    // Price List Features
    'features' => [
        'feature_1' => [
            'name' => 'Feature 1',
            'plans' => [
                'basic',
                'enhanced',
                'premier',
            ],
        ],
        'feature_2' => [
            'name' => 'Feature 2',
            'plans' => [
                'basic',
                'enhanced',
                'premier',
            ],
        ],
        'feature_3' => [
            'name' => 'Feature 3',
            'plans' => [
                'basic',
                'enhanced',
                'premier',
            ],
        ],
        'feature_4' => [
            'name' => 'Feature 4',
            'plans' => [
                'enhanced',
                'premier',
            ],
        ],
        'feature_5' => [
            'name' => 'Feature 5',
            'plans' => [
                'enhanced',
                'premier',
            ],
        ],
        'feature_6' => [
            'name' => 'Feature 6',
            'plans' => [
                'premier',
            ],
        ],
        'feature_7' => [
            'name' => 'Feature 7',
            'plans' => [
                'premier',
            ],
        ],
        'feature_8' => [
            'name' => 'Feature 8',
            'plans' => [
                'premier',
            ],
        ],
    ],

    // Price List > Table Styles
    'pricing_table_type' => 'default', // options: default, with_vat, with_features

    // Recaptcha
    'recaptcha' => [
        'enabled' => true, // Enable or disable reCAPTCHA, default is true
        'min_score' => 0.3, // Lowest 0.1, highest 1.0
    ],

    /**
     * V3: Number of areas to display on the map, (old v3 Functionality).
     * @deprecated
     */
    'number_of_areas' => 5,

    /**
     * V3: Minimum price per square meter, (old v3 Functionality).
     * @deprecated
     */
    'min_price' => 28,

    /**
     * V3: Price lists for different plans, (old v3 Functionality).
     * @deprecated
     */
    'basic' => [
        '50' => 28,
        '60' => 30,
        '70' => 31,
        '80' => 33,
        '90' => 34,

        '100' => 35,
        '110' => 37,
        '120' => 38,
        '130' => 40,
        '140' => 41,
        '150' => 43,
        '160' => 44,
        '170' => 46,
        '180' => 47,
        '190' => 49,

        '200' => 50,
        '210' => 52,
        '220' => 53,
        '230' => 55,
        '240' => 56,
        '250' => 58,
        '260' => 59,
        '270' => 61,
        '280' => 62,
        '290' => 63,

        '300' => 65,
        '325' => 69,
        '350' => 72,
        '375' => 76,

        '400' => 80,
        '425' => 83,
        '450' => 87,
        '475' => 91,

        '500' => 94,
        '525' => 98,
        '550' => 102,
        '575' => 105,

        '600' => 109,
        '650' => 116,

        '700' => 124,
        '750' => 131,

        '800' => 138,
        '850' => 154,

        '900' => 161,
        '950' => 169,

        '1000' => 176,
        '1050' => 184,

        '1100' => 191,
        '1150' => 198,

        '1200' => 206,
        '1250' => 213,

        '1300' => 220,
        '1350' => 228,

        '1400' => 235,
        '1450' => 242,

        '1500' => 250,
        '1550' => 257,

        '1600' => 264,
        '1650' => 272,

        '1700' => 279,
        '1750' => 287,

        '1800' => 294,
        '1850' => 310,

        '1900' => 317,
        '1950' => 324,

        '2000' => 332,
    ],
    'enhanced' => [],
    'premier' => [],

    /**
     * V3: Standard treatments and visits per year, (old v3 Functionality).
     * @deprecated
     */
    'basic_treatments' => 14,
    'basic_visits' => 5,

    'enhanced_treatments' => 17,
    'enhanced_visits' => 7,

    'premier_treatments' => 20,
    'premier_visits' => 8,
];
