<?php

declare(strict_types=1);

namespace Bongo\Estimate;

use Bongo\Estimate\Commands\UpgradeToV4Command;
use Bongo\Estimate\Components\Backend\RadiusMap;
use Bongo\Estimate\Components\Backend\ServiceDropdown;
use Bongo\Framework\Providers\AbstractServiceProvider;
use Illuminate\Support\Facades\Blade;

class EstimateServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'estimate';

    public array $commands = [
        UpgradeToV4Command::class,
    ];

    public function boot(): void
    {
        parent::boot();

        $this->bootAssets();
        $this->bootComponents();
    }

    protected function bootAssets(): void
    {
        $this->publishes([__DIR__.'/../public/' => public_path()], 'estimate:assets');
    }

    protected function bootComponents(): void
    {
        Blade::component(RadiusMap::class, 'radius-map');
        Blade::component(ServiceDropdown::class, 'estimate-service-dropdown');
    }
}
