<?php

declare(strict_types=1);

namespace Bongo\Estimate\Events;

use Bongo\Estimate\Models\EstimateItem;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class EstimateItemDeleted
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public EstimateItem $estimateItem;

    public function __construct(EstimateItem $estimateItem)
    {
        $this->estimateItem = $estimateItem;
    }
}
