<?php

declare(strict_types=1);

namespace Bongo\Estimate\Exceptions;

use Exception;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Http\RedirectResponse;

class NoPlansAvailableException extends Exception
{
    /** @throws BindingResolutionException */
    public function render(): RedirectResponse
    {
        session()->forget('estimate_id');
        session()->forget('estimate_item_id');

        return redirect()->to(
            setting('package::estimate.custom_estimate_url', '/more-assistance')
        );
    }
}
