<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Controllers\Backend;

use Bongo\Estimate\Events\EstimateUpdated;
use Bongo\Estimate\Http\Requests\Backend\UpdateEstimateRequest;
use Bongo\Estimate\Models\Estimate;
use Bongo\Framework\Http\Controllers\AbstractController;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class EstimateController extends AbstractController
{
    protected Estimate $estimate;

    public function __construct(Estimate $estimate)
    {
        $this->estimate = $estimate;
    }

    public function index(): View
    {
        return view('estimate::backend.details.index');
    }

    public function show(Estimate $estimate): View
    {
        return view('estimate::backend.details.show', compact('estimate'));
    }

    public function update(UpdateEstimateRequest $request, Estimate $estimate): RedirectResponse
    {
        $estimate->update($request->all());
        event(new EstimateUpdated($estimate));

        return redirect()
            ->route('backend.estimate.index')
            ->success(trans('estimate::backend.update_success'));
    }
}
