<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Controllers\Frontend;

use Bongo\Estimate\Actions\FindEstimate;
use Bongo\Estimate\Exceptions\EstimateNotFoundException;
use Bongo\Framework\Http\Controllers\AbstractController;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Log;

class ResetController extends AbstractController
{
    /** @throws EstimateNotFoundException */
    public function address(): RedirectResponse
    {
        // Find the estimate or fail
        if (! $estimate = FindEstimate::byUuid(session('estimate_id'))) {
            if (config('app.debug')) {
                Log::error('Reset Address - Estimate not found', [
                    'estimate_id' => session('estimate_id'),
                ]);
            }
            throw new EstimateNotFoundException();
        }

        // Reset the address details and continue
        $estimate->resetAddress();

        return redirect()->route('frontend.estimate.step_1.show');
    }

    /** @throws EstimateNotFoundException */
    public function contact(): RedirectResponse
    {
        // Find the estimate or fail
        if (! $estimate = FindEstimate::byUuid(session('estimate_id'))) {
            if (config('app.debug')) {
                Log::error('Reset Contact - Estimate not found', [
                    'estimate_id' => session('estimate_id'),
                ]);
            }
            throw new EstimateNotFoundException();
        }

        // Reset the address details and continue
        $estimate->resetContact();

        return redirect()->route('frontend.estimate.step_1.show');
    }

    /** @throws EstimateNotFoundException */
    public function item(): RedirectResponse
    {
        // Find the estimate or fail
        if (! FindEstimate::byUuid(session('estimate_id'))) {
            if (config('app.debug')) {
                Log::error('Reset Item - Estimate not found', [
                    'estimate_id' => session('estimate_id'),
                ]);
            }
            throw new EstimateNotFoundException();
        }

        // Reset the estimate item and continue
        session()->forget('estimate_item_id');

        return redirect()->route('frontend.estimate.step_1.show');
    }
}
