<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

class Circle
{
    protected int $milesMultiplier = 3959;

    protected int $kilometersMultiplier = 6380;

    protected float $latitude;

    protected float $longitude;

    protected float $radius;

    protected int $zoom = 8;

    protected array $coordinates = [];

    public function getCoordinates(): array
    {
        $pi = pi();
        $latitude = ($this->latitude * $pi) / 180;
        $longitude = ($this->longitude * $pi) / 180;
        $d = $this->radius / $this->milesMultiplier;

        $this->coordinates = [];

        for ($i = 0; $i <= 360; $i += $this->zoom) {
            $bearing = $i * $pi / 180;

            $pLat = asin(sin($latitude) * cos($d) + cos($latitude) * sin($d) * cos($bearing));
            $pLng = (($longitude + atan2(sin($bearing) * sin($d) * cos($latitude), cos($d) - sin($latitude) * sin($pLat))) * 180) / $pi;
            $pLat = ($pLat * 180) / $pi;

            $this->coordinates[] = [$pLat, $pLng];
        }

        return $this->coordinates;
    }

    public function setLatitude(string $latitude): self
    {
        $this->latitude = floatval($latitude);

        return $this;
    }

    public function setLongitude(string $longitude): self
    {
        $this->longitude = floatval($longitude);

        return $this;
    }

    public function setRadius(string $radius): self
    {
        $this->radius = floatval($radius);

        return $this;
    }

    public function setZoom(int $zoom): self
    {
        $this->zoom = $zoom;

        return $this;
    }
}
