<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

use Exception;

class Path
{
    protected array $coordinates = [];

    protected string $strokeColor = '0xff0000';

    protected string $strokeWeight = '2';

    protected string $fillColor = '0x00FF00';

    public function getCoordinates(): array
    {
        return $this->coordinates;
    }

    public function setCoordinates(array $coordinates): self
    {
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getStrokeColor(): string
    {
        return $this->strokeColor;
    }

    /**
     * @throws Exception
     */
    public function setStrokeColor(string $color): self
    {
        if (! str_starts_with($color, '#') && ! str_starts_with($color, '0x')) {
            throw new Exception('Only hex or hexadecimal colors are allowed.');
        }

        $this->strokeColor = str_starts_with($color, '#')
            ? str_replace('#', '0x', $color)
            : $color;

        return $this;
    }

    public function getStrokeWeight(): string
    {
        return $this->strokeWeight;
    }

    public function setStrokeWeight(string $strokeWeight): self
    {
        $this->strokeWeight = $strokeWeight;

        return $this;
    }

    public function getFillColor(): string
    {
        return $this->fillColor;
    }

    /**
     * @throws Exception
     */
    public function setFillColor(string $color): self
    {
        if (! str_starts_with($color, '#') && ! str_starts_with($color, '0x')) {
            throw new Exception('Only hex or hexadecimal colors are allowed.');
        }

        $this->fillColor = str_starts_with($color, '#')
            ? str_replace('#', '0x', $color)
            : $color;

        return $this;
    }
}
