<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

class RadiusMapUrl extends URLGenerator
{
    public function generate(): string
    {
        $url = self::BASE_URL;
        $url .= $this->getMapParams();
        $url .= $this->getPathParams();

        return $url;
    }

    public function encodeCoordinates(array $coordinates): string
    {
        assert(is_array($coordinates));

        $encoded = (new PolylineEncoder($coordinates))->dpEncode();

        return urlencode($encoded['points']);
    }
}
