<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

class StaticMap extends Map
{
    protected array $markers = [];

    public function getMarkers(): array
    {
        return $this->markers;
    }

    public function setMarkers(array $markers): self
    {
        $this->markers = $markers;

        return $this;
    }

    public function addMarker(Marker $marker): self
    {
        $this->markers[] = $marker;

        return $this;
    }

    public function generateUrl(): string
    {
        return (new StaticMapUrl($this))->generate();
    }
}
