<?php

declare(strict_types=1);

use Bongo\Estimate\Interfaces\StatusInterface;
use Bongo\Estimate\Seeders\PackageSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

return new class() extends Migration
{
    public function up(): void
    {
        Schema::create(Str::plural('estimate'), function (Blueprint $table) {

            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // Default fields
            $table->unsignedBigInteger('number')
                ->nullable();

            $table->date('date')
                ->nullable();

            $table->unsignedTinyInteger('step')
                ->default(1);

            $table
                ->enum('status', [
                    StatusInterface::PENDING,
                    StatusInterface::ACCEPTED,
                    StatusInterface::REJECTED,
                ])
                ->default(StatusInterface::PENDING);

            // Address
            $table->string('line_1')
                ->nullable();

            $table->string('line_2')
                ->nullable();

            $table->string('line_3')
                ->nullable();

            $table->string('city')
                ->nullable();

            $table->string('county')
                ->nullable();

            $table->string('postcode')
                ->nullable();

            $table->string('latitude')
                ->nullable();

            $table->string('longitude')
                ->nullable();

            // Contact
            $table->string('first_name')
                ->nullable();

            $table->string('last_name')
                ->nullable();

            $table->string('email')
                ->nullable();

            $table->string('phone')
                ->nullable();

            $table->tinyInteger('accepted_terms')
                ->default(0);

            $table->tinyInteger('marketing_emails')
                ->default(0);

            // Measurement data
            $table->longText('areas')
                ->nullable();

            $table->tinyInteger('marker_moved')
                ->default(0);

            $table->string('total_area_m2')
                ->nullable();

            $table->unsignedInteger('cost_per_m2')
                ->nullable();

            // Price / totals
            $table->unsignedInteger('subtotal')
                ->nullable();

            $table->unsignedInteger('tax_rate')
                ->nullable();

            $table->unsignedInteger('tax')
                ->nullable();

            $table->unsignedInteger('total')
                ->nullable();

            // Audit
            $table->unsignedInteger('created_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('updated_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('deleted_by')
                ->nullable()
                ->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });

        // If the package table exists then seed the package
        if (Schema::hasTable('packages')) {
            Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
        }
    }

    public function down(): void
    {
        Schema::dropIfExists(Str::plural('estimate'));
    }
};
