<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('estimates', 'sent_at')) {
            Schema::table('estimates', function (Blueprint $table) {
                $table->timestamp('sent_at')
                    ->nullable()
                    ->after('updated_at');
            });
        }
    }

    public function down(): void
    {
        Schema::table('estimates', function (Blueprint $table) {
            $table->dropColumn('sent_at');
        });
    }
};
