<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;

return new class() extends Migration
{
    public function up(): void
    {
        DB::statement("
            ALTER TABLE `estimates`
            CHANGE COLUMN `status`
            `status` ENUM('draft','pending','accepted','rejected')
            DEFAULT 'draft'
        ");
        DB::statement("
            UPDATE `estimates`
            SET `status` = 'draft'
            WHERE `status` = 'pending'
        ");
    }

    public function down(): void
    {
        DB::statement("
            UPDATE `estimates`
            SET `status` = 'pending'
            WHERE `status` = 'draft'
        ");
        DB::statement("
            ALTER TABLE `estimates`
            CHANGE COLUMN `status`
            `status` ENUM('pending','accepted','rejected')
            DEFAULT 'pending'
        ");
    }
};
