<?php

declare(strict_types=1);

namespace Bongo\Estimate\Models;

use Bongo\Framework\Casts\Pence;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\SoftDeletes;

class EstimatePlanItem extends AbstractModel
{
    use HasUUID;
    use SoftDeletes;

    /** @var array */
    protected $fillable = [
        'estimate_plan_id',
        'area_m2',
        'cost_per_m2',
        'sort_order',
    ];

    /** @var array */
    protected $casts = [
        'area_m2' => 'int',
        'cost_per_m2' => Pence::class,
    ];
}
