<?php

declare(strict_types=1);

namespace Bongo\Estimate\Services;

use Spatie\Geocoder\Exceptions\CouldNotGeocode;
use Spatie\Geocoder\Geocoder;

class GoogleGeoCoder extends Geocoder
{
    /**
     * @throws CouldNotGeocode
     */
    public function getCoordinatesForAddress(string $address): array
    {
        $response = $this->getAllCoordinatesForAddress($address);

        // Try and return the most accurate result,
        // priority is given to ROOFTOP, then RANGE_INTERPOLATED, then GEOMETRIC_CENTER
        foreach ($response as $result) {
            if ($result['accuracy'] === 'ROOFTOP') {
                return $result;
            }
            if ($result['accuracy'] === 'RANGE_INTERPOLATED') {
                return $result;
            }
            if ($result['accuracy'] === 'GEOMETRIC_CENTER') {
                return $result;
            }
        }

        // Otherwise just return the first result, which is probably 'APPROXIMATE'
        return $response[0];
    }
}
