<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

trait HasAreas
{
    public function initializeHasAreas(): void
    {
        $this->mergeFillable([
            'areas',
            'total_area_m2',
        ]);
        $this->mergeCasts([
            'total_area_m2' => 'float',
        ]);
    }

    public function getAreas(): array
    {
        return ! empty($this->areas)
            ? json_decode($this->areas)
            : [];
    }
}
