<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

use Bongo\Framework\Traits\Contact\HasAcceptedTerms;
use Bongo\Framework\Traits\Contact\HasEmail;
use Bongo\Framework\Traits\Contact\HasFirstName;
use Bongo\Framework\Traits\Contact\HasLastName;
use Bongo\Framework\Traits\Contact\HasMarketingEmails;
use Bongo\Framework\Traits\Contact\HasPhone;

trait HasContact
{
    use HasAcceptedTerms;
    use HasEmail;
    use HasFirstName;
    use HasLastName;
    use HasMarketingEmails;
    use HasPhone;

    public function getNameAttribute(): string
    {
        return implode(' ', array_filter([
            $this->first_name,
            $this->last_name,
        ]));
    }

    public function resetContact(): void
    {
        $this->first_name = null;
        $this->last_name = null;
        $this->email = null;
        $this->phone = null;
        $this->county = null;
        $this->accepted_terms = null;
        $this->marketing_emails = null;
        $this->save();
    }
}
