<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

trait HasDefault
{
    public function initializeHasDefault(): void
    {
        $this->mergeFillable(['default']);
        $this->mergeCasts(['default' => 'boolean']);
    }

    public static function bootHasDefault(): void
    {
        static::saving(function ($model) {
            if ($model->default === true) {
                self::query()
                    ->where('id', '!=', $model->id)
                    ->update(['default' => false]);
            }
        });
    }
}
