<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

trait HasSteps
{
    public function initializeHasSteps(): void
    {
        $this->mergeFillable(['step']);
    }

    public function stepIs(int $step): bool
    {
        return $this->step === $step;
    }

    public function stepIsGt(int $step): bool
    {
        return $this->step > $step;
    }

    public function stepIsGte(int $step): bool
    {
        return $this->step >= $step;
    }

    public function setStepAs(int $step): void
    {
        $this->update(['step' => $step]);
    }
}
