
@component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-2 items-center">
        <div class="col-span-1">
            <a href="{{ route('backend.estimate.item.show', [$estimate, $estimateItem]) }}"
               title="View"
               class="block font-semibold hover:text-primary-500 focus:text-primary-600"
            >
                <span>
                    {{ $estimateItem->hasService() ? $estimateItem->service->name : '-- --' }}
                </span>
            </a>
            <div class="text-sm">
                <span>
                    Ref: {{ config('estimate.number_prefix').$estimateItem->number }}
                </span>
                &nbsp;|&nbsp;
                <span
                    @class([
                        'font-bold',
                        'text-yellow-500' => $estimateItem->isPending(),
                        'text-green-400' => $estimateItem->isAccepted(),
                        'text-red-500' => $estimateItem->isRejected(),
                    ])
                >
                    {{ ucwords($estimateItem->status) }}
                </span>
            </div>
            <div class="text-sm">
                <span>
                    Step: {{ $estimateItem->step ?? '-- --' }}
                </span>
                &nbsp;|&nbsp;
                <span>
                    Area M2: {{ $estimateItem->total_area_m2 }}
                </span>
            </div>
        </div>

        <div class="col-span-1 text-left lg:text-right">
            @if($estimateItem->hasPrices())
                @foreach($estimateItem->prices as $price)
                    <div class="text-xs leading-5">
                        <span>
                            {{ $price->hasPlan() ? $price->plan->name : '-- --' }}:
                        </span>
                        <span class="font-medium">
                            {{ ! empty($price->total) ? '£'.number_format($price->total, 2) : '-- --'}}
                        </span>
                    </div>
                @endforeach
            @endif
        </div>
    </div>

    @slot('footer')
        <div class="grid grid-cols-2 gap-2 items-center">
            <div class="col-span-1">
                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-gray-200 text-gray-500">
                    {{ ! empty($estimateItem->created_at) ? $estimateItem->created_at->format('d/m/Y H:i') : '-- --' }}
                </span>
            </div>
            <div class="col-span-1 text-right">
                <span class="inline-flex rounded-sm shadow-sm">
                    <a href="{{ route('backend.estimate.item.show', [$estimate, $estimateItem]) }}"
                       @class([
                           'inline-flex items-center px-2.5 py-1.5 text-xs font-medium rounded-md',
                           'transition duration-150 ease-in-out border border-gray-300 text-gray-700 bg-white',
                           'hover:text-gray-500 focus:outline-none focus:shadow-outline-blue',
                           'focus:border-blue-300 active:text-gray-800 active:bg-gray-50'
                       ])
                       title="View Item"
                       aria-label="View Item"
                    >
                        View
                    </a>
                </span>
            </div>
        </div>
    @endslot
@endcomponent
