@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ config('estimate.number_prefix').$estimateItem->number }} - {{ $estimate->name }}
        @slot('actions')
            @backButton([
                'name' => 'Estimate Items',
                'url' => route('backend.estimate.item.index', $estimate)
            ])
        @endslot
    @endcomponent

    @component('blade::content_body')
        @include('estimate::backend.details.partials.navigation')

        <section class="md:grid md:grid-cols-2 md:gap-6">

            <div class="md:col-span-1 md:row-span-3">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    @if(count($estimateItem->getAreas()) > 0)
                        <div class="map">
                            <img class="img-fluid" src="{{ $estimateItem->getStaticMap() }}" alt="">
                        </div>
                    @else
                        <div class="message text-center">
                            <div class="message-text font-semibold">
                                Map: No Areas Found
                            </div>
                        </div>
                    @endif
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        @if(count($estimateItem->getAreas()) > 1)
                            @foreach($estimateItem->getAreas() as $area)
                                <div class="sm:col-span-1">
                                    <div class="form-group">
                                        <label class="text-sm leading-5 font-medium text-gray-500">
                                            Area - {{ $area->label }}
                                        </label>
                                        <div class="mt-1 text-sm leading-5 text-gray-900">
                                            {{ $area->no_of_m2 ? number_format($area->no_of_m2, 2) : 0 }} m2
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif

                        <div class="sm:col-span-1">
                            <div class="form-group">
                                <label class="text-sm leading-5 font-medium text-gray-500">
                                    Total Area
                                </label>
                                <div class="mt-1 text-sm leading-5 text-gray-900">
                                    {{ ! empty($estimateItem->total_area_m2) ? number_format($estimateItem->total_area_m2, 2) : 0 }} m2
                                </div>
                            </div>
                        </div>

                        @if($estimateItem->hasSinglePrice())
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Cost Per m2',
                                    'value' => $estimateItem->getSinglePrice()->cost_per_m2
                                ])
                            </div>
                        @endif
                    </div>
                @endcomponent
            </div>

            @if($estimateItem->hasSinglePrice() && $singlePrice = $estimateItem->getSinglePrice())
                <div class="md:col-span-1">
                    @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Subtotal',
                                    'value' => ! empty($singlePrice->subtotal) ? '£'.number_format($singlePrice->subtotal, 2) : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Tax Rate',
                                    'value' => ! empty($singlePrice->tax_rate) ? $singlePrice->tax_rate.'%' : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Tax',
                                    'value' => ! empty($singlePrice->tax) ? '£'.number_format($singlePrice->tax, 2) : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Total',
                                    'value' => ! empty($singlePrice->total) ? '£'.number_format($singlePrice->total, 2) : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Installments',
                                    'value' => config('estimate.chargeable_treatments_per_year')
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Per Month',
                                    'value' => ! empty($singlePrice->price_per_month) ? '£'.number_format($singlePrice->price_per_month, 2) : null
                                ])
                            </div>
                        </div>
                    @endcomponent
                </div>
            @endif

            @if($estimateItem->hasMultiplePrices())
                @php
                    $thStyle = 'px-2 py-2 text-left text-sm font-semibold text-gray-900';
                    $tdStyle = 'px-2 py-2 text-sm font-medium text-gray-900';
                @endphp
                <div class="md:col-span-1">
                    @component('blade::card', ['class' => 'p-0 m-0', 'cardClass' => 'mb-4 md:mb-0'])
                        <div class="w-full overflow-x-auto">
                            <div class="inline-flex items-center w-full px-2 py-2">
                                <table class="table w-full border border-gray-300 m-0">
                                    <thead class="bg-gray-200">
                                        <tr>
                                            <th class="{{ $thStyle }}">
                                                Plan
                                            </th>
                                            <th class="{{ $thStyle }}">
                                                Cost M2
                                            </th>
                                            <th class="{{ $thStyle }}">
                                                Subtotal
                                            </th>
                                            <th class="{{ $thStyle }}">
                                                VAT
                                            </th>
                                            <th class="{{ $thStyle }}">
                                                Total
                                            </th>
                                            <th class="{{ $thStyle }}">
                                                Per Month
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white">
                                        @foreach($estimateItem->prices as $price)
                                            <tr @class(['bg-gray-100' => $loop->even])>
                                                <td class="{{ $tdStyle }}">
                                                    {{ $price->hasPlan() ? $price->plan->name : '-- --' }}
                                                </td>
                                                <td class="{{ $tdStyle }}">
                                                    £{{ ! empty($price->cost_per_m2) ? number_format($price->cost_per_m2, 2) : '0.00' }}
                                                </td>
                                                <td class="{{ $tdStyle }}">
                                                    £{{ ! empty($price->subtotal) ? number_format($price->subtotal, 2) : '0.00' }}
                                                </td>
                                                <td class="{{ $tdStyle }}">
                                                    £{{ ! empty($price->tax) ? number_format($price->tax, 2) : '0.00' }}
                                                </td>
                                                <td class="{{ $tdStyle }}">
                                                    £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}
                                                </td>
                                                <td class="{{ $tdStyle }}">
                                                    £{{ ! empty($price->price_per_month) ? number_format($price->price_per_month, 2) : '0.00' }}
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endcomponent
                </div>
            @endif
        </section>

    @endcomponent
@stop
