@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $estimateLocation->name }}
        @slot('actions')
            @deleteButton([
                'class' => 'btn-danger mr-2',
                'name' => trans('estimate::backend.location_delete'),
                'url' => route('backend.estimate_location.destroy', $estimateLocation->id)
            ])
            @backButton([
                'name' => trans('estimate::backend.location_index'),
                'url' => route('backend.estimate_location.index')
            ])
            @editButton([
                'name' => trans('estimate::backend.location_edit'),
                'url' => route('backend.estimate_location.edit', $estimateLocation->id)
            ])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Name',
                                'value' => $estimateLocation->name
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($estimateLocation->status) ? ucwords($estimateLocation->status) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Fill Colour',
                                'value' => $estimateLocation->fill
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Stroke Colour',
                                'value' => $estimateLocation->stroke
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Latitude',
                                'value' => $estimateLocation->latitude
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Longitude',
                                'value' => $estimateLocation->longitude
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Radius In Miles',
                                'value' => $estimateLocation->radius
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Default',
                                'value' => $estimateLocation->default ? 'Yes' : 'No'
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-2">
                <x-radius-map />
            </div>

        </section>
    @endcomponent

@stop
