@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('estimate::backend.plan_index') }}
        @slot('actions')
            @linkButton([
                'name' => 'Estimates',
                'url' => route('backend.estimate.index')
            ])
            @backButton([
                'name' => trans('dashboard::backend.index')
            ])
            @createButton([
                'name' => trans('estimate::backend.plan_create'),
                'url' => route('backend.estimate_plan.create')
            ])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.estimate_plan.datatable') }}"
            resource-url="{{ route('backend.estimate_plan.index') }}"
            order-by="name"
            v-cloak
        >
            <template slot="custom-filters" slot-scope="{updateFilters, getFilterValue}">
                <data-table-filter :first-child="true">
                    <select class="form-input w-full block rounded-sm pr-10 sm:text-sm sm:leading-5"
                            :value="getFilterValue('status')"
                            @change="event => updateFilters(event, 'status')"
                    >
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
                        </svg>
                    </div>
                </data-table-filter>
            </template>

            <template
                slot="default"
                slot-scope="{items, itemIndex, isSelected, setAsSelectedItem, viewUrl, editUrl}"
            >
                <div class="grid grid-cols-2 gap-3">

                    <v-card
                        v-for="(item, index) in items"
                        :key="item.id"
                        :id="itemIndex(item, index)"
                        :class="['col-span-1', { selected : isSelected(item, index) }]"
                        @click="setAsSelectedItem(item, index)"
                    >
                        <template slot="left">
                            <div class="md:flex items-center">
                                <div class="text-left">
                                    <a :href="viewUrl(item)" title="View"
                                       class="block font-semibold hover:text-primary-500 focus:text-primary-600"
                                    >
                                        @{{ item.service }} > @{{ item.name }}
                                    </a>
                                    <div v-if="item.status || item.default">
                                        <span v-if="item.status"
                                              :class="['text-sm', item.status === 'active' ? 'text-green-400' : 'text-red-500']"
                                        >
                                            @{{ item.status | ucwords }}
                                        </span>
                                        <span v-if="item.status && item.default" class="text-xs text-gray-400">|</span>
                                        <span v-if="item.default === true"
                                              :class="['text-sm text-yellow-400']"
                                        >
                                            Default
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </template>

                        <template slot="right">
                            <v-button :link="viewUrl(item)">View</v-button>
                            <v-button :link="editUrl(item)">Edit</v-button>
                        </template>
                    </v-card>

                </div>
            </template>

        </data-table>
    @endcomponent
@stop
