@extends('estimate::frontend.layout')

@section('body_class', 'estimate-page')
@section('page_title', 'Step 3 > '.setting('package::estimate.step_3'))
@section('meta_title', 'Step 3 > '.setting('package::estimate.step_3'))
@section('meta_description', 'Step 3 > '.setting('package::estimate.step_3'))

@section('wizard_content')
    <div class="wizard-content">
        @include($viewPartials['thank_you_text'])

        <section class="quote-details">
            <div class="row">
                <div class="col-md-6">
                    <div class="contact-details">
                        @include($viewPartials['contact_details'])
                    </div>
                    <div class="measurements mt-4">
                        @include($viewPartials['measurement_summary'])
                    </div>
                    @if($estimateItem->hasSinglePrice() && $singlePrice = $estimateItem->getSinglePrice())
                        @include($viewPartials['single_price'], ['singlePrice' => $singlePrice])
                    @endif
                </div>
                <div class="col-md-6">
                    @include($viewPartials['static_map'])
                </div>
            </div>
        </section>

        @if($estimateItem->hasMultiplePrices())
            @includeIf($viewPartials['pricing_table'])
        @endif
        @include($viewPartials['footer_text'])
    </div>

    <div class="wizard-actions">
        <div class="wizard-next">
            @include($viewPartials['create_another_button'])
            @include($viewPartials['book_treatment_button'])
        </div>
        <div class="wizard-previous">
            @include($viewPartials['back_to_home_button'])
        </div>
    </div>
@stop
