<section class="pricing-table">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th class="plan">Plan</th>
                <th class="total">Per Treatment</th>
                <th class="per-month">Per Month</th>
            </tr>
        </thead>
        <tbody>
            @foreach($estimateItem->prices as $price)
                <tr class="{{ $price->plan->key ?? '' }}">
                    <td class="plan">
                        <div>{{ $price->plan->name ?? '-- --' }}</div>
                        <div class="installments">
                            {{ $price->plan?->treatments ?? '-- --' }} Treatments
                            Across {{ $price->plan?->visits ?? '-- --' }} Visits
                        </div>
                    </td>
                    <td class="price total">
                        £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}
                    </td>
                    <td class="price per-month">
                        £{{ ! empty($price->price_per_month) ? number_format($price->price_per_month, 2) : '0.00' }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</section>
