<section class="pricing-table with-features">
    <div class="align-middle min-w-full"
         style="overflow: hidden; overflow-x: scroll"
    >
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th class="treatment">
                        Treatment
                    </th>
                    @foreach($estimateItem->prices as $price)
                        <th class="{{ $price->plan->key ?? '' }}">
                            <div>{{ $price->plan->name ?? '-- --' }}</div>
                            <div class="installments">
                                {{ $price->plan?->treatments ?? '-- --' }} Treatments
                                Across {{ $price->plan?->visits ?? '-- --' }} Visits
                            </div>
                        </th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach(config('estimate.features') as $key => $feature)
                    <tr class="{{ $key }}">
                        <td class="feature">
                            {{ $feature['name'] ?? '-- --' }}
                        </td>
                        @foreach($estimateItem->prices as $price)
                            <td class="{{ $price->plan->key }}">
                                @if($price->plan->hasFeature($key))
                                    <i aria-hidden="true" class="fas fa-check-circle text-success"></i>
                                @else
                                    <i aria-hidden="true" class="fas fa-times-circle text-danger"></i>
                                @endif
                            </td>
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td class="price-from">Pricing From</td>
                    @foreach($estimateItem->prices as $price)
                        <td class="{{ ! empty($price->plan->name) ? make_id($price->plan->name) : '' }}">
                            <div>
                                <span class="price">
                                    £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}
                                </span>
                                <span class="per-treatment">
                                    / Per Treatment
                                </span>
                            </div>
                            <div>
                                <span class="price">
                                    £{{ ! empty($price->price_per_month) ? number_format($price->price_per_month, 2) : '0.00' }}
                                </span>
                                <span class="per-month">
                                    / Per Month
                                </span>
                            </div>
                        </td>
                    @endforeach
                </tr>
            </tfoot>
        </table>
    </div>
</section>
