@php
    $sharedStyle = 'padding-top: 5px; padding-right: 5px; padding-bottom: 5px; padding-left: 5px; border:0; vertical-align:middle; text-align: center;';
    $thStyle = 'color: #ffffff; border: 1px solid #dddddd;';
    $tdStyle = 'color: #222222; border: 1px solid #dddddd; border-top: 0;';

    $tdEvenStyle = 'background: #ffffff;';
    $tdOddStyle = 'background: #eeeeee;';

    $enabled = 'color: #198754;';
    $disabled = 'color: #DC3545;';

    $dark = 'background: #222222; color: #ffffff;';
    $basic = 'background: #CD7F32; color: #ffffff;';
    $enhanced = 'background: #C0C0C0; color: #ffffff;';
    $premier = 'background: #E6C200; color: #ffffff;';
@endphp

<table class="pricing-table with-features" width="100%" cellpadding="0" border="0" cellspacing="0">
    <thead>
        <tr>
            <th style="{{ $sharedStyle }} {{ $thStyle }} {{ $dark }}">
                Treatment
            </th>
            @foreach($estimateItem->prices as $price)
                @php
                    if ($price->plan->name == 'Premier') {
                        $background = $basic;
                    } elseif($price->plan->name == 'Enhanced') {
                        $background = $enhanced;
                    } else {
                        $background = $basic;
                    }
                @endphp
                <th style="{{ $sharedStyle }} {{ $thStyle }} {{ $background }}">
                    <div>{{ $price->plan->name ?? '-- --' }}</div>
                    <div style="font-size: 10px; line-height: 12px;">
                        {{ $price->plan?->treatments ?? '-- --' }} Treatments
                    </div>
                    <div style="font-size: 10px; line-height: 12px;">
                        Across {{ $price->plan?->visits ?? '-- --' }} Visits
                    </div>
                </th>
            @endforeach
        </tr>
    </thead>

    <tbody>
        @foreach(config('estimate.features') as $key => $feature)
            <tr class="{{ $key }}">
                <td style="{{ $sharedStyle }} {{ $tdStyle }}">
                    {{ $feature['name'] ?? '-- --' }}
                </td>
                @foreach($estimateItem->prices as $price)
                    <td style="{{ $sharedStyle }} {{ $tdStyle }}">
                        @if($price->plan->hasFeature($key))
                            <span style="{{ $enabled }}">&check;</span>
                        @else
                            <span style="{{ $disabled }}">&cross;</span>
                        @endif
                    </td>
                @endforeach
            </tr>
        @endforeach
    </tbody>

    <tfoot>
        <tr>
            <td style="{{ $sharedStyle }} {{ $tdStyle }} {{ $dark }}">
                Pricing From
            </td>
            @foreach($estimateItem->prices as $price)
                <td style="{{ $sharedStyle }} {{ $tdStyle }} {{ $basic }}">
                    <div style="line-height: 16px;">
                        <span class="price">
                            £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}
                        </span>
                        <span style="font-size: 10px;">
                            / Per Treatment
                        </span>
                    </div>
                    <div style="line-height: 16px;">
                        <span class="price">
                            £{{ ! empty($price->price_per_month) ? number_format($price->price_per_month, 2) : '0.00' }}
                        </span>
                        <span style="font-size: 10px;">
                            / Per Month
                        </span>
                    </div>
                </td>
            @endforeach
        </tr>
    </tfoot>
</table>
