<?php

declare(strict_types=1);

namespace Bongo\Estimate\Concerns;

use Bongo\Framework\Casts\DateTime;

trait CanBeExported
{
    public function initializeCanBeExported(): void
    {
        $this->mergeFillable(['exported_at', 'export_error']);
        $this->mergeCasts(['exported_at' => DateTime::class]);
    }

    public function hasExportedAt(): bool
    {
        return ! empty($this->exported_at);
    }

    public function hasExportError(): bool
    {
        return ! empty($this->export_error);
    }
}
