<?php

declare(strict_types=1);

namespace Bongo\Estimate\Data;

use Illuminate\Database\Eloquent\Model;

class SqueegeeData
{
    public function toArray(Model $row): array
    {
        return [
            'customer_name' => $this->setCustomerName($row),
            'customer_marketing_accepted' => $this->setCustomerMarketingAccepted($row),
            'customer_address' => $this->setCustomerAddress($row),
            'customer_phone' => $this->setCustomerPhone($row),
            'customer_phone_other' => $this->setCustomerPhoneOther($row),
            'customer_email' => $this->setCustomerEmail($row),
            'customer_latitude' => $this->setCustomerLatitude($row),
            'customer_longitude' => $this->setCustomerLongitude($row),
            'customer_notes' => $this->setCustomerNotes($row),
            'customer_source' => $this->setCustomerSource($row),
            'customer_default_notification' => $this->setCustomerDefaultNotification($row),

            'auto_generate_invoice_on_job_completion' => $this->setAutoGenerateInvoiceOnJobCompletion($row),
            'auto_send_invoice_when_created' => $this->setAutoSendInvoiceWhenCreated($row),
            'hide_default_invoice_notes' => $this->setHideDefaultInvoiceNotes($row),
            'hide_gocardless_signup_from_invoice' => $this->setHideGoCardlessSignupFromInvoice($row),
            'hide_gocardless_from_invites' => $this->setHideGoCardlessFromInvites($row),
            'hide_job_prices_from_worker' => $this->setHideJobPricesFromWorker($row),
            'hide_stripe_from_invites' => $this->setHideStripeFromInvites($row),
            'hide_stripe_pay_button_from_invoice' => $this->setHideStripePayButtonFromInvoice($row),
            'hide_tax' => $this->setHideTax($row),

            'customer_invoice_notes' => $this->setCustomerInvoiceNotes($row),
            'customer_payment_period' => $this->setCustomerPaymentPeriod($row),
            'customer_require_signature' => $this->setCustomerRequireSignature($row),
            'customer_take_payment_on_invoiced' => $this->setCustomerTakePaymentOnInvoiced($row),
            'customer_tax_rate' => $this->setCustomerTaxRate($row),

            'external_id' => $this->setExternalId($row),
            'customer_inactive' => $this->setCustomerInactive($row),
            'customer_balance' => $this->setCustomerBalance($row),

            'job_reference' => $this->setJobReference($row),
            'job_assignee' => $this->setJobAssignee($row),
            'job_address' => $this->setJobAddress($row),
            'job_latitude' => $this->setJobLatitude($row),
            'job_longitude' => $this->setJobLongitude($row),
            'job_description' => $this->setJobDescription($row),
            'job_price' => $this->setJobPrice($row),

            'job_last_done' => $this->setJobLastDone($row),
            'job_date' => $this->setJobDate($row),
            'job_first_date' => $this->setJobFirstDate($row),
            'job_first_price' => $this->setJobFirstPrice($row),
            'job_frequency_interval' => $this->setJobFrequencyInterval($row),
            'job_frequency_type' => $this->setJobFrequencyType($row),
            'job_day_of_week' => $this->setJobDayOfWeek($row),
            'job_day_of_month' => $this->setJobDayOfMonth($row),
            'job_week_of_month' => $this->setJobWeekOfMonth($row),

            'job_time' => $this->setJobTime($row),
            'job_service' => $this->setJobService($row),
            'job_round' => $this->setJobRound($row),
            'job_duration' => $this->setJobDuration($row),
        ];
    }

    protected function setCustomerName(Model $row): ?string
    {
        return $row->first_name.' '.$row->last_name;
    }

    protected function setCustomerMarketingAccepted(Model $row): ?string
    {
        return $row->marketing_emails ? 'y' : 'n';
    }

    protected function setCustomerAddress(Model $row): ?string
    {
        $addressParts = array_filter([
            $row->line_1,
            $row->line_2,
            $row->line_3,
            $row->city,
            $row->county,
            $row->postcode,
        ]);

        return implode(', ', $addressParts);
    }

    protected function setCustomerPhone(Model $row): ?string
    {
        return $row->phone ?? null;
    }

    protected function setCustomerPhoneOther(Model $row): ?string
    {
        return $row->phone_other ?? null;
    }

    protected function setCustomerEmail(Model $row): ?string
    {
        return $row->email ?? null;
    }

    protected function setCustomerLatitude(Model $row): ?string
    {
        return $row->latitude ?? null;
    }

    protected function setCustomerLongitude(Model $row): ?string
    {
        return $row->longitude ?? null;
    }

    protected function setCustomerNotes(Model $row): ?string
    {
        return $row->notes ?? null;
    }

    protected function setCustomerSource(Model $row): string
    {
        return $row->source ?? 'website';
    }

    protected function setCustomerDefaultNotification(Model $row): string
    {
        return $row->default_notification ?? 'email';
    }

    protected function setAutoGenerateInvoiceOnJobCompletion(Model $row): string
    {
        return $row->auto_generate_invoice_on_job_completion ?? 'n';
    }

    protected function setAutoSendInvoiceWhenCreated(Model $row): string
    {
        return $row->auto_send_invoice_when_created ?? 'n';
    }

    protected function setHideDefaultInvoiceNotes(Model $row): string
    {
        return $row->hide_default_invoice_notes ?? 'n';
    }

    protected function setHideGoCardlessSignupFromInvoice(Model $row): string
    {
        return $row->hide_gocardless_signup_from_invoice ?? 'n';
    }

    protected function setHideGoCardlessFromInvites(Model $row): string
    {
        return $row->hide_gocardless_from_invites ?? 'n';
    }

    protected function setHideJobPricesFromWorker(Model $row): string
    {
        return $row->hide_job_prices_from_worker ?? 'n';
    }

    protected function setHideStripeFromInvites(Model $row): string
    {
        return $row->hide_stripe_from_invites ?? 'n';
    }

    protected function setHideStripePayButtonFromInvoice(Model $row): string
    {
        return $row->hide_stripe_pay_button_from_invoice ?? 'n';
    }

    protected function setHideTax(Model $row): string
    {
        return $row->hide_tax ?? 'n';
    }

    protected function setCustomerInvoiceNotes(Model $row): ?string
    {
        return $row->customer_invoice_notes ?? null;
    }

    protected function setCustomerPaymentPeriod(Model $row): int
    {
        return $row->payment_period ?? 30;
    }

    protected function setCustomerRequireSignature(Model $row): string
    {
        return $row->require_signature ?? 'y';
    }

    protected function setCustomerTakePaymentOnInvoiced(Model $row): string
    {
        return $row->take_payment_on_invoiced ?? 'n';
    }

    protected function setCustomerTaxRate(Model $row): int
    {
        return $row->tax_rate ?? 20;
    }

    protected function setExternalId(Model $row): ?string
    {
        return $row->uuid ?? null;
    }

    protected function setCustomerInactive(Model $row): ?string
    {
        return $row->inactive ?? null;
    }

    protected function setCustomerBalance(Model $row): ?float
    {
        return $row->balance ?? null;
    }

    protected function setJobReference(Model $row): ?string
    {
        return ! empty($row->number)
            ? config('estimate.number_prefix').$row->number
            : null;
    }

    protected function setJobAssignee(Model $row): ?string
    {
        return $row->job_assignee ?? null;
    }

    protected function setJobAddress(Model $row): ?string
    {
        return $this->setCustomerAddress($row);
    }

    protected function setJobLatitude(Model $row): ?string
    {
        return $this->setCustomerLatitude($row);
    }

    protected function setJobLongitude(Model $row): ?string
    {
        return $this->setCustomerLongitude($row);
    }

    protected function setJobDescription(Model $row): ?string
    {
        return $row->service_name ?? null;
    }

    protected function setJobPrice(Model $row): ?int
    {
        return $row->job_price ?? null;
    }

    protected function setJobLastDone(Model $row): ?string
    {
        return $row->job_last_done ?? null;
    }

    protected function setJobDate(Model $row): ?string
    {
        return $row->job_date ?? null;
    }

    protected function setJobFirstDate(Model $row): ?string
    {
        return $row->job_first_date ?? null;
    }

    protected function setJobFirstPrice(Model $row): ?int
    {
        return $row->job_first_price ?? null;
    }

    protected function setJobFrequencyInterval(Model $row): ?int
    {
        return $row->job_frequency_interval ?? null;
    }

    protected function setJobFrequencyType(Model $row): ?string
    {
        return $row->job_frequency_type ?? null;
    }

    protected function setJobDayOfWeek(Model $row): ?string
    {
        return $row->job_day_of_week ?? null;
    }

    protected function setJobDayOfMonth(Model $row): ?int
    {
        return $row->job_day_of_month ?? null;
    }

    protected function setJobWeekOfMonth(Model $row): ?int
    {
        return $row->job_week_of_month ?? null;
    }

    protected function setJobTime(Model $row): ?string
    {
        return $row->job_time ?? null;
    }

    protected function setJobService(Model $row): ?string
    {
        return $row->service_name ?? null;
    }

    protected function setJobRound(Model $row): ?string
    {
        return $row->job_round ?? null;
    }

    protected function setJobDuration(Model $row): ?string
    {
        return $row->job_duration ?? null;
    }
}
