<?php

declare(strict_types=1);

namespace Bongo\Estimate\Exceptions;

use Exception;
use Illuminate\Http\RedirectResponse;

class NoServiceSelectedException extends Exception
{
    public function render(): RedirectResponse
    {
        return redirect()
            ->route('frontend.estimate.step_1.show')
            ->with([
                'message_type' => 'danger',
                'message' => trans('estimate::frontend.service_not_selected'),
            ]);
    }
}
