<?php

declare(strict_types=1);

namespace Bongo\Estimate\Exports;

use Illuminate\Contracts\View\View;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class SqueegeeExport implements FromView, WithStyles
{
    protected Collection $rows;

    public function __construct(Collection $rows)
    {
        $this->rows = $rows;
    }

    public function styles(Worksheet $sheet): array
    {
        return [
            1 => ['font' => ['bold' => true]], // Style the first row as bold text.
        ];
    }

    public function view(): View
    {
        return view('estimate::exports.squeegee', [
            'rows' => $this->rows,
        ]);
    }
}
