<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Controllers\Backend;

use Bongo\Estimate\Http\Resources\LocationResource;
use Bongo\Estimate\Models\EstimateLocation;
use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Illuminate\Database\Eloquent\Builder;

class LocationDatatableController extends AbstractDatatableController
{
    protected EstimateLocation $estimateLocation;

    public function __construct(EstimateLocation $estimateLocation)
    {
        $this->estimateLocation = $estimateLocation;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->estimateLocation->newQuery();
    }

    protected function setResults()
    {
        $this->results = LocationResource::collection($this->query->distinct()->get());
    }
}
