<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Controllers\Backend;

use Bongo\Estimate\Http\Resources\PlanResource;
use Bongo\Estimate\Models\EstimatePlan;
use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Illuminate\Database\Eloquent\Builder;

class PlanDatatableController extends AbstractDatatableController
{
    protected EstimatePlan $estimatePlan;

    public function __construct(EstimatePlan $estimatePlan)
    {
        $this->estimatePlan = $estimatePlan;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->estimatePlan
            ->with(['service'])
            ->orderBy('estimate_service_id')
            ->orderBy('name');
    }

    protected function setResults()
    {
        $this->results = PlanResource::collection($this->query->distinct()->get());
    }
}
