<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Requests\Backend;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StorePlanRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'estimate_service_id' => 'required|exists:estimate_services,id',
            'name' => [
                'required', 'max:75',
                Rule::unique('estimate_plans')
                    ->where('estimate_service_id', $this->estimate_service_id),
            ],
            'status' => 'required|in:pending,active,inactive',
            'default' => 'required|boolean',
            'treatments' => 'required|integer|min:1',
            'chargeable_treatments' => 'required|integer|min:1',
            'min_price' => 'required|numeric|min:0',
            'visits' => 'required|numeric|min:1',
        ];
    }
}
