<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Requests\Backend;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdatePlanRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'estimate_service_id' => 'required|exists:estimate_services,id',
            'name' => [
                'required', 'max:75',
                Rule::unique('estimate_plans')
                    ->where('estimate_service_id', $this->estimate_service_id)
                    ->ignore($this->estimatePlan),
            ],
            'status' => 'required|in:pending,active,inactive',
            'default' => 'required|boolean',
        ];
    }
}
