<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PlanResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'name' => $this->name,
            'service' => $this->service?->name ?? '-- --',
            'status' => $this->status,
            'default' => $this->default,
            'created_at' => ! empty($this->created_at)
                ? $this->created_at->format('d/m/Y H:i')
                : null,
        ];
    }
}
