<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

use Illuminate\Support\Facades\Storage;

class ImageGenerator
{
    protected string $url;

    protected string $name;

    protected string $path;

    public function __construct(string $url, string $name, string $path)
    {
        $this->url = $url;
        $this->name = $name;
        $this->path = rtrim(ltrim($path, '/'), '/');
    }

    public function generate(): string
    {
        // Get the file contents and save
        $filePath = "public/{$this->path}";
        $fileName = $this->name;
        $file = file_get_contents($this->url);
        Storage::put("{$filePath}/{$fileName}", $file);

        return "{$filePath}/{$fileName}";
    }
}
