<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

class Marker
{
    public const ANCHOR = [
        'top',
        'bottom',
        'left',
        'right',
        'center',
        'topleft',
        'topright',
        'bottomleft',
        'bottomright',
    ];

    public const COLOR = [
        'black',
        'brown',
        'green',
        'purple',
        'yellow',
        'blue',
        'gray',
        'orange',
        'red',
        'white',
    ];

    public const SIZE = [
        'tiny',
        'mid',
        'small',
    ];

    protected array $locations = [];

    protected string $anchor = 'center';

    protected string $size = 'mid';

    protected string $color = 'red';

    protected ?string $label = null;

    protected ?string $icon = null;

    public function getLocations(): array
    {
        return $this->locations;
    }

    public function setLocations(array $locations): self
    {
        $this->locations = $locations;

        return $this;
    }

    public function addLocation(array $location): self
    {
        $this->locations[] = new Point($location);

        return $this;
    }

    public function getAnchor(): string
    {
        return $this->anchor;
    }

    public function setAnchor(string $anchor): self
    {
        $this->anchor = $anchor;

        return $this;
    }

    public function getSize(): string
    {
        return $this->size;
    }

    public function setSize(string $size): self
    {
        $this->size = $size;

        return $this;
    }

    public function getColor(): string
    {
        return $this->color;
    }

    public function setColor(string $color): self
    {
        $this->color = $color;

        return $this;
    }

    public function getLabel(): ?string
    {
        return $this->label;
    }

    public function setLabel(string $label): self
    {
        // Must be a single uppercase alphanumeric character only e.g 'A'
        $this->label = strtoupper($label);

        return $this;
    }

    public function getIcon(): ?string
    {
        return $this->icon;
    }

    public function setIcon(string $icon): self
    {
        // Full url to the icons location on the web
        $this->icon = $icon;

        return $this;
    }
}
