<?php

declare(strict_types=1);

use Bongo\Framework\Interfaces\StatusInterface;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        Schema::create('estimate_plans', function (Blueprint $table) {

            $table->increments('id');

            $table->uuid('uuid')
                ->index();

            $table->unsignedInteger('estimate_service_id')
                ->nullable()
                ->index();

            $table->foreign('estimate_service_id')
                ->references('id')
                ->on('estimate_services')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->string('name')
                ->nullable();

            $table->string('key')
                ->nullable()
                ->index();

            $table->unsignedInteger('min_price')
                ->nullable();

            $table->unsignedInteger('treatments')
                ->nullable();

            $table->unsignedInteger('chargeable_treatments')
                ->nullable();

            $table->unsignedInteger('visits')
                ->nullable();

            $table->tinyInteger('default')
                ->default(0);

            $table
                ->enum('status', [
                    StatusInterface::PENDING,
                    StatusInterface::ACTIVE,
                    StatusInterface::INACTIVE,
                ])
                ->default(StatusInterface::PENDING);

            $table->unsignedInteger('created_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('updated_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('deleted_by')
                ->nullable()
                ->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('estimate_plans');
    }
};
