<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        Schema::create('estimate_plan_items', function (Blueprint $table) {

            $table->increments('id');

            $table->uuid('uuid')
                ->index();

            $table->unsignedInteger('estimate_plan_id')
                ->index();

            $table->foreign('estimate_plan_id')
                ->references('id')
                ->on('estimate_plans')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->unsignedInteger('area_m2')
                ->nullable();

            $table->unsignedInteger('cost_per_m2')
                ->nullable();

            $table->integer('sort_order')
                ->nullable();

            $table->unsignedInteger('created_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('updated_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('deleted_by')
                ->nullable()
                ->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('estimate_plan_items');
    }
};
