<?php

declare(strict_types=1);

use Bongo\Estimate\Interfaces\PriceTypeInterface;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('estimate_plans', 'price_type')) {
            Schema::table('estimate_plans', function (Blueprint $table) {
                $table
                    ->enum('price_type', [
                        PriceTypeInterface::PER_TREATMENT_MONTH,
                        PriceTypeInterface::PER_TREATMENT,
                        PriceTypeInterface::PER_MONTH,
                    ])
                    ->default(PriceTypeInterface::PER_TREATMENT_MONTH)
                    ->after('visits');
            });
        }
    }

    public function down(): void
    {
        Schema::table('estimate_plans', function (Blueprint $table) {
            $table->dropColumn('price_type');
        });
    }
};
