<?php

declare(strict_types=1);

use Bongo\Estimate\Interfaces\CalculationTypeInterface;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('estimate_plans', 'calculation_type')) {
            Schema::table('estimate_plans', function (Blueprint $table) {
                $table
                    ->enum('calculation_type', [
                        CalculationTypeInterface::FLAT_PRICE,
                        CalculationTypeInterface::PRICE_PER_M2,
                    ])
                    ->default(CalculationTypeInterface::FLAT_PRICE)
                    ->after('price_type');
            });
        }
    }

    public function down(): void
    {
        Schema::table('estimate_plans', function (Blueprint $table) {
            $table->dropColumn('calculation_type');
        });
    }
};
