<?php

declare(strict_types=1);

namespace Bongo\Estimate\Models;

use Bongo\Estimate\Database\Factories\EstimateItemPriceFactory;
use Bongo\Estimate\Traits\HasTotals;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class EstimateItemPrice extends AbstractModel
{
    use HasFactory;
    use HasTotals;
    use HasUUID;
    use SoftDeletes;

    /** @var array */
    protected $fillable = [
        'estimate_item_id',
        'estimate_plan_id',
        'estimate_plan_item_id',
    ];

    /** @var array */
    protected $casts = [];

    public function item(): BelongsTo
    {
        return $this->belongsTo(EstimateItem::class, 'estimate_item_id');
    }

    public function hasItem(): bool
    {
        $this->loadMissing('item');

        return ! empty($this->estimate_item_id) && ! is_null($this->item);
    }

    public function plan(): BelongsTo
    {
        return $this->belongsTo(EstimatePlan::class, 'estimate_plan_id');
    }

    public function hasPlan(): bool
    {
        $this->loadMissing('plan');

        return ! empty($this->estimate_plan_id) && ! is_null($this->plan);
    }

    public function planItem(): BelongsTo
    {
        return $this->belongsTo(EstimatePlanItem::class, 'estimate_plan_item_id');
    }

    public function hasPlanItem(): bool
    {
        $this->loadMissing('planItem');

        return ! empty($this->estimate_plan_item_id) && ! is_null($this->planItem);
    }

    protected static function newFactory(): EstimateItemPriceFactory
    {
        return EstimateItemPriceFactory::new();
    }
}
