<?php

declare(strict_types=1);

use Bongo\Estimate\Http\Controllers\Backend\EstimateController;
use Bongo\Estimate\Http\Controllers\Backend\EstimateDatatableController;
use Bongo\Estimate\Http\Controllers\Backend\EstimateItemController;
use Bongo\Estimate\Http\Controllers\Backend\ExportController;
use Bongo\Estimate\Http\Controllers\Backend\LocationController;
use Bongo\Estimate\Http\Controllers\Backend\LocationDatatableController;
use Bongo\Estimate\Http\Controllers\Backend\PlanController;
use Bongo\Estimate\Http\Controllers\Backend\PlanDatatableController;
use Bongo\Estimate\Http\Controllers\Backend\ServiceController;
use Bongo\Estimate\Http\Controllers\Backend\ServiceDatatableController;
use Illuminate\Support\Facades\Route;

Route::as('estimate.')
    ->prefix(config('estimate.backend_prefix'))
    ->group(function () {

        Route::get('/', [EstimateController::class, 'index'])
            ->name('index');

        Route::get('datatable', [EstimateDatatableController::class, 'index'])
            ->name('datatable');

        Route::get('/export', [ExportController::class, 'index'])
            ->name('export');

        // Estimate/{estimate}/
        Route::prefix('{estimate}')
            ->group(function () {
                Route::get('/', [EstimateController::class, 'show'])
                    ->name('show');

                Route::post('update', [EstimateController::class, 'update'])
                    ->name('update');

                Route::as('item.')
                    ->prefix(config('estimate.item_prefix'))
                    ->group(function () {

                        Route::get('/', [EstimateItemController::class, 'index'])
                            ->name('index');

                        // items/{estimateItem}/
                        Route::prefix('{estimateItem}')
                            ->group(function () {
                                Route::get('/', [EstimateItemController::class, 'show'])
                                    ->name('show');
                            });
                    });
            });
    });

// estimate-services
Route::as('estimate_service.')
    ->prefix(config('estimate.service_prefix'))
    ->group(function () {

        Route::get('/', [ServiceController::class, 'index'])
            ->name('index');

        Route::get('create', [ServiceController::class, 'create'])
            ->name('create');

        Route::post('store', [ServiceController::class, 'store'])
            ->name('store');

        Route::get('datatable', [ServiceDatatableController::class, 'index'])
            ->name('datatable');

        // service/{estimateService}/
        Route::prefix('{estimateService}')
            ->group(function () {

                Route::get('/', [ServiceController::class, 'show'])
                    ->name('show');

                Route::get('edit', [ServiceController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [ServiceController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [ServiceController::class, 'destroy'])
                    ->name('destroy');
            });
    });

// estimate-locations
Route::as('estimate_location.')
    ->prefix(config('estimate.location_prefix'))
    ->group(function () {

        Route::get('/', [LocationController::class, 'index'])
            ->name('index');

        Route::get('create', [LocationController::class, 'create'])
            ->name('create');

        Route::post('store', [LocationController::class, 'store'])
            ->name('store');

        Route::get('datatable', [LocationDatatableController::class, 'index'])
            ->name('datatable');

        // location/{estimateLocation}/
        Route::prefix('{estimateLocation}')
            ->group(function () {

                Route::get('/', [LocationController::class, 'show'])
                    ->name('show');

                Route::get('edit', [LocationController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [LocationController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [LocationController::class, 'destroy'])
                    ->name('destroy');
            });
    });

// estimate-plans
Route::as('estimate_plan.')
    ->prefix(config('estimate.plan_prefix'))
    ->group(function () {

        Route::get('/', [PlanController::class, 'index'])
            ->name('index');

        Route::get('create', [PlanController::class, 'create'])
            ->name('create');

        Route::post('store', [PlanController::class, 'store'])
            ->name('store');

        Route::get('datatable', [PlanDatatableController::class, 'index'])
            ->name('datatable');

        // plan/{estimatePlan}/
        Route::prefix('{estimatePlan}')
            ->group(function () {

                Route::get('/', [PlanController::class, 'show'])
                    ->name('show');

                Route::get('edit', [PlanController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [PlanController::class, 'update'])
                    ->name('update');

                Route::get('duplicate', [PlanController::class, 'duplicate'])
                    ->name('duplicate');

                Route::delete('delete', [PlanController::class, 'destroy'])
                    ->name('destroy');
            });
    });
