<?php

declare(strict_types=1);

use Bongo\Estimate\Http\Controllers\Frontend\ResetController;
use Bongo\Estimate\Http\Controllers\Frontend\SearchController;
use Bongo\Estimate\Http\Controllers\Frontend\Step1Controller;
use Bongo\Estimate\Http\Controllers\Frontend\Step2Controller;
use Bongo\Estimate\Http\Controllers\Frontend\Step3Controller;
use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;

Route::prefix(config('estimate.prefix'))
    ->as('estimate.')
    ->group(function () {

        Route::get('/', [Step1Controller::class, 'index'])
            ->name('index');

        Route::get('/reset-address', [ResetController::class, 'address'])
            ->name('reset_address');

        Route::get('/reset-contact', [ResetController::class, 'contact'])
            ->name('reset_contact');

        Route::get('/reset-item', [ResetController::class, 'item'])
            ->name('reset_item');

        Route::post('search', [SearchController::class, 'index'])
            ->middleware(ProtectAgainstSpam::class)
            ->name('search');

        Route::prefix('step-1')
            ->as('step_1.')
            ->group(function () {
                Route::get('/', [Step1Controller::class, 'show'])
                    ->name('show');

                Route::post('store', [Step1Controller::class, 'store'])
                    ->middleware(ProtectAgainstSpam::class)
                    ->name('store');
            });

        Route::prefix('step-2')
            ->as('step_2.')
            ->group(function () {
                Route::get('/', [Step2Controller::class, 'show'])
                    ->name('show');

                Route::post('store', [Step2Controller::class, 'store'])
                    ->middleware(ProtectAgainstSpam::class)
                    ->name('store');
            });

        Route::prefix('step-3')
            ->as('step_3.')
            ->group(function () {
                Route::get('/', [Step3Controller::class, 'show'])
                    ->name('show');
            });
    });
