<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

use Bongo\Estimate\Interfaces\CalculationTypeInterface;

trait HasCalculationType
{
    public function initializeHasCalculationType(): void
    {
        $this->mergeFillable(['calculation_type']);
    }

    public function scopeFlatPrice($query)
    {
        return $query->where('calculation_type', CalculationTypeInterface::FLAT_PRICE);
    }

    public function isFlatPrice(): bool
    {
        return $this->calculation_type === CalculationTypeInterface::FLAT_PRICE;
    }

    public function scopePricePerM2($query)
    {
        return $query->where('calculation_type', CalculationTypeInterface::PRICE_PER_M2);
    }

    public function isPricePerM2(): bool
    {
        return $this->calculation_type === CalculationTypeInterface::PRICE_PER_M2;
    }

    public function getCalculationTypeLabelAttribute(): string
    {
        $options = $this->getCalculationTypeOptions();

        return $options[$this->calculation_type] ?? 'Unknown';
    }

    public function getCalculationTypeOptions(): array
    {
        return [
            CalculationTypeInterface::FLAT_PRICE => 'Flat Price',
            CalculationTypeInterface::PRICE_PER_M2 => 'Price Per M2',
        ];
    }
}
