<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

use Bongo\Framework\Casts\Date;

trait HasDate
{
    public function initializeHasDate(): void
    {
        $this->mergeFillable(['date']);
        $this->mergeCasts(['date' => Date::class]);
    }

    public static function bootHasDate(): void
    {
        static::creating(function ($model) {
            $model->date = now()->format('Y-m-d');
        });
    }
}
